export interface Product {
  id: string;
  name: string;
  barcode?: string; // Optional barcode
  category: string;
  price: number; // Selling price
  cost: number; // Buying cost
  stock: number;
  minStock: number;
  supplierId?: string; // Optional link to Supplier
}

export interface CartItem extends Product {
  quantity: number;
}

export interface Invoice {
  id: string;
  customerName: string;
  date: string;
  timestamp: number; // Added for easier date filtering
  items: CartItem[];
  totalAmount: number;
  discount: number;
  finalAmount: number;
}

export interface DashboardStats {
  totalProducts: number;
  lowStockCount: number;
  totalInventoryValue: number;
  totalSales: number;
}

export interface Customer {
  id: string;
  name: string;
  phone: string;
  email: string;
}

export interface Category {
  id: string;
  name: string;
  description: string;
}

export interface Supplier {
  id: string;
  name: string;
  contactPerson: string;
  phone: string;
}

export interface User {
  id: string;
  fullName: string;
  username: string;
  password: string;
  role: 'admin' | 'staff';
}

export interface StoreSettings {
  name: string;
  address: string;
  currency: string;
  phone1: string;
  phone2: string;
}